/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.util;

import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class FileUtils {
    private FileUtils() {
    }

    public static void moveDir(Path temp, Path dest) {
        try {
            Files.move(temp, dest, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            throw new IllegalStateException("Atomic move not supported for " + temp + " to " + dest, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to move " + temp + " to " + dest, e);
        }
    }

    public static void deleteDirectory(Path dir) {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to delete directory " + dir, e);
        }
    }

    public static void forceMkDirs(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create directory: " + path, e);
        }
    }
}

